% Matlab program to draw phase diagrams in the baseline Diamond overlapping generations model.
% By Marc P. B. Klemp, November 2009.

function Utility = U(S, W, R)
global rho;
global Dist_util Utility_temp;

if Dist_util == 1
    Utility_temp = v1(W-S) + v2((1+R)*S)/(1+rho);    % This is the intertemporal utility function.
else
    Utility_temp = v(W-S) + v((1+R)*S)/(1+rho);      % This is the intertemporal utility function.
end

for i = 1:length(Utility_temp)
    if isreal(Utility_temp(i))
        Utility_temp(i) = Utility_temp(i);
    else
        Utility_temp(i) = NaN;
    end
end

Utility = Utility_temp;